let isNotDirect = false;
let hostValue = "";
let portValue = 0;
let typeValue = "";
let isActive = false

// Set the default list on installation.
browser.runtime.onInstalled.addListener(details => {
	// console.log(`detail: ${details}`);
	// Get the stored list
	browser.storage.local.get(data => {
		// console.log(`data ${data}`);
		// console.log(`data ${JSON.stringify(data)}`);
		 if (data.config && data.config.direct == false) {
				isActive = true
			} else {
				isActive = false
			}
			updateIcon()
	});
});

// Listen for send message
browser.runtime.onMessage.addListener((message) => {
	if (message.action === 'setProxy'
		&& message.config.host.length > 0) {
		console.log("setProxy");
		browser.storage.local.set({ config: message.config })
	} else if (message.action === 'clearProxy') {
		console.log("clearProxy");
		browser.storage.local.set({ config: message.config })
		isActive = false
		updateIcon()
	}
});

// Listen for changes in the blocked list
browser.storage.onChanged.addListener(changeData => {
	// console.log(`changeData: ${JSON.stringify(changeData)}`);
	if (typeof changeData.config == 'undefined') {
		return
	}

	isNotDirect = !changeData.config.newValue.direct
	hostValue = changeData.config.newValue.host
	portValue = changeData.config.newValue.port
	typeValue = changeData.config.newValue.type
	if (isNotDirect) {
		isActive = true
		updateIcon()
	} else {
		isActive = false
		updateIcon()
	}
});

function shouldProxyRequest() {
	return isNotDirect;
}

function handleProxyRequest(requestInfo) {
	// console.log(`requestInfo: ${requestInfo}`);
	// console.log(`requestInfo JSONStr: ${JSON.stringify(requestInfo)}`);
	// console.log(`typeValue:${typeValue} host${hostValue} port${portValue}`);
	if (shouldProxyRequest(requestInfo)) {
		
		return { type: typeValue, host: hostValue, port: portValue };
	}
	return { type: "direct" };
}

// Listen for request
browser.proxy.onRequest.addListener(handleProxyRequest, {
	urls: ["<all_urls>"],
});

// Log any errors from the proxy script
browser.proxy.onError.addListener(error => {
	console.error(`Proxy error: ${error.message}`);
});

// update icon
function updateIcon() {
	const iconPath = isActive ? {
		"16": "/img/logo_on16.png",
		"32": "/img/logo_on32.png",
		"48": "/img/logo_on48.png",
		"128": "/img/logo_on128.png"
	} : {
		"16": "/img/logo16.png",
		"32": "/img/logo32.png",
		"48": "/img/logo48.png",
		"128": "/img/logo128.png"
	};

	browser.browserAction.setIcon({ path: iconPath });
}
