
const loadView = {
  init: function () {
    let listData = []
    let curConnectObj = {}
    const webUrl = 'https://www.922proxy.com/'
    const totorialUrl = 'https://www.922proxy.com/zh-tw/help/user_guide/120'

    // logo icon
    $('.logoBox .logoIcon').on('click', function () {
      activeStatisFun('Connect_website')
      window.open(`${webUrl}`)
    })

    // add new proxy
    $('.listEmpty .addNewProxy').on('click', function () {
      window.open('proxySet.html')
    })

    $('.bottomBar .manage').on('click', function () {
      window.open('proxySet.html')
    })

    // tutorial
    $('.listEmpty .tutorial').on('click', function () {
      activeStatisFun('Tutorial')
      window.open(`${totorialUrl}`)
    })

    $('.listEmpty .website').on('click', function () {
      activeStatisFun('Connect_website')
      window.open(`${webUrl}`)
    })

    $('.bottomBar .tutorial').on('click', function () {
      activeStatisFun('Tutorial')
      window.open(`${totorialUrl}`)
    })
    
    getListData()
    function getListData() {
      browser.storage.local.get({ list: [] }, function (items) {
        listData = items.list;
        // console.log("list::", listData);
        initView();
      });
    }
    
    function initView() {

      if (listData.length == 0) {
        if ($('.section_box').hasClass('active')) {
          $('.section_box').removeClass('active')
        }
        return
      }

      $('.section_box').addClass('active')
      drawListView()
    }

    function drawListView() {
      curConnectObj = {}
      let html = ''
      for (let i = 0; i < listData.length; i++) {
        let obj = listData[i]
        if (obj.isConnect == 1) {
          curConnectObj = obj
        }

        html += `<li class="${obj.isConnect == 1 && 'active'}">
              <div class="left">
                <p class="proxyname">${obj.Proxy_name}</p>
                <span class="host">${obj.Host_name}</span>
              </div>
              <div class="right">
                <div data-index="${i}" class="waitConnect">Connect</div>
                <div class="connected">
                  <img src="./img/icon2.png" alt="" />
                  <span>Connected</span>
                </div>
              </div>
            </li>
        `
      }
      $('.listBox .listBoxItem').html(html)
      waitConnectEvent()

      if (Object.keys(curConnectObj).length > 0) {
        $('.navTip').addClass('active')
        $('.cruConnectProxyName').text(`${curConnectObj.Proxy_name}`)
        $('.cruConnectHostName').text(`${curConnectObj.Host_name}`)
      } else {
        if ($('.navTip').hasClass('active')) {
          $('.navTip').removeClass('active')
        }
      }
    }

    function waitConnectEvent() {
      $('.waitConnect').off()
      $('.waitConnect').on('click', function () {
        let i = $(this).data("index");
        let obj = listData[i]
        for (let i = 0; i < listData.length; i++) {
          let itemObj = listData[i]
          if (itemObj.Proxy_name === obj.Proxy_name
            && itemObj.Host_name === obj.Host_name
            && itemObj.Port === obj.Port
            && itemObj.Username === obj.Username
            && itemObj.select === obj.select
            && itemObj.Password === obj.Password
          ) {
            itemObj.isConnect = 1
          } else {
            itemObj.isConnect = 0
          }
        }
        browser.storage.local.set({ list: listData }, function () {
          getListData()
        });

        setProxy(obj)
      })
    }

    disConnectEvenet()
    function disConnectEvenet() {
      $('.connectTip .disconnect').on('click', function () {
        clearProxy()
        for (let i = 0; i < listData.length; i++) {
          let itemObj = listData[i]
          itemObj.isConnect = 0
        }

        browser.storage.local.set({ list: listData }, function () {
          getListData()
        });
      })
    }

    function setProxy(obj) {

      if (obj.Host_name == 0) {
        vh.Toast("Host can not empty")
        return
      }

      if (obj.Port == 0) {
        vh.Toast("Port can not empty")
        return
      }

      let type = ""
      const selectType = obj.select
      if (selectType == 'Http' || selectType == 'Https') {
        type = 'http'
      } else if (selectType == 'Socks5'){
        type = 'socks'
      }


      activeStatisFun('Connect', obj)
      browser.runtime.sendMessage({ action: 'updateProxySet' });
      browser.runtime.sendMessage({
        
        action: 'setProxy', config: {
          direct: false,
          type: type,
          host: obj.Host_name,
          port: obj.Port
        }
      });
    }

    function clearProxy() {
      browser.runtime.sendMessage({ action: 'updateProxySet' });
      browser.runtime.sendMessage({
        action: 'clearProxy', config: {
          direct: true,
          type: "",
          host: "",
          port: 0
        }
      });
    }
  }
}

$(function () {
  loadView.init()
})

