const loadView = {
  init: function () {

    const webUrl = 'https://www.922proxy.com/'
    let list = []
    let canSave = false
    let del_index = -1;
    
    browser.runtime.onMessage.addListener((message) => {
      if (message.action === 'updateProxySet') {
        getListData()
      }
    });

    getListData()
    function getListData() {
      browser.storage.local.get({ list: [] }, function (items) {
        list = items.list;
        // console.log("list::", list);
        list_init();
      });
    }

    function defaultConfig() {
      $(".save_success_tip").hide()
      $('.save_fail_tip').hide()
      $(".del_tip").hide();
      canSave = false
      del_index = -1
    }

    $('.add_proxy_btn').on('click', function () {
      list.push({
        Proxy_name: '',
        select: 'Http',
        Host_name: '',
        Port: '',
        Username: '',
        Password: '',
        is_show: 0,
        isConnect: 0
      })
      activeStatisFun('Add_new_Proxy')
      list_init()
    })


    function list_init() {
      defaultConfig()
      let html = ''
      if (list.length == 0) {
        if ($('.list_box').hasClass('active')) {
          $('.list_box').removeClass('active')
        }
      } else {
        $('.list_box').addClass('active')
      }

      for (let i = 0; i < list.length; i++) {
        let info = list[i];
        html += `
        <tr data-index="${i}" class="has-before ${info.isConnect == 1 ? 'connected_active' : ''}">
          <th>
            <div class="inputBox">
              <input data-index="${i}" class="Proxy_name" type="text" placeholder="Proxy Name" value="${info.Proxy_name}"></>
            </div>
          </th>
          <th>
            <div class="lh-select">
              <div class="lh-select_k" data-index="${i}">
                <span class="lh-select-val" data-index="${i}">${info.select}</span>
                <span class="iconfont"></span>
              </div>
              <ul class="lh-select-op">
                <li data-index="Http">Http</li>
                <li data-index="Https">Https</li>
                <li data-index="Socks5">Socks5</li>
              </ul>
            </div>
          </th>
          <th>
            <div class="inputBox">
              <input data-index="${i}" class="Host_name" type="text" placeholder="Hostname" value="${info.Host_name}">
            </div>
          </th>
          <th>
            <div class="inputBox">
              <input data-index="${i}" class="Port" type="text" placeholder="Port" value="${info.Port}">
            </div>
          </th>
          <th>
            <div class="inputBox">
              <input data-index="${i}" class="Username" type="text" placeholder="Username" value="${info.Username}">
            </div>
          </th>
          <th>
            <div class="inputBox">
              <input data-index="${i}" class="Password" type="${info.is_show == 0 ? "password" : "text"}" placeholder="Password" value="${info.Password}">
              <div data-index="${i}"  class="eye ${(info.is_show == 1) && 'eye_open'}"></div>
            </div>
            <div data-index="${i}" class="${info.isConnect == 1 ? 'connected' : 'delete'}">${info.isConnect == 1 ? '' : 'Delete'}</div>
          </th>
        </tr>
        `
      }

      $('.listTbody').html(html)
      let trs = $('.listTbody').find('tr')
      // let i=0
      trs.each(function () {
        
        let thisTr = $(this);
        let i = $(this).data("index");
        if (list[i].isConnect == 1) {
          thisTr.find('input').attr('disabled', 'disabled');
          thisTr.find('inputBox').addClass('no-hover')
        }
        // if (i == trs.length - 1) {
        //   if (thisTr.hasClass('has-before')) {
        //     thisTr.removeClass('has-before')
        //     thisTr.addClass('no-before')
        //   }
        // }
        // i++
      })
      addlhSelectListEvent()
      input_blur_init()
    }

    function addlhSelectListEvent() {
      
      $(".lh-select_k").off();
      $(".lh-select_k").on("click", function () {
        let i = $(this).data("index");
        if (list[i].isConnect == 1) {
          return
        }

        let that = this;
        let display = $(that).next().css('display');
        if (display != 'none') {
          return;
        }
        setTimeout(function () {
          $(that).next().toggle();
          $(that).parent().addClass('lh-select-active')
        }, 50);
      });
      $(".lh-select-op li").off();
      $(".lh-select-op li").on("click", function () {
        $(this).siblings().removeClass("op_a");
        $(this).addClass("op_a");
        $(".lh-select-op").hide();
        $(".lh-select-op").parent().removeClass('lh-select-active')
        let index = $(this).index();
        canSave = true
        // console.log("li index::", index);
        let txt = $(this).text();
        $(this).parent().prev().children("span.lh-select-val").text(txt);
        let i = $(this).parent().prev().children("span.lh-select-val").data("index");
        list[i].select = txt;
        // save = false;
        // save_btn_set()
      });
    }

    function input_blur_init() {
      $("input").on("blur", function () {
        var i = $(this).data("index");
        var val = $(this).val();
        var name = $(this).attr("class");
        input_blur(i, name, val);
      });

      $("input").on({
        copy: function () {
        },
        paste: function () {
          let that = this
          inputPaste(that)
        },
        cut: function () {
        }
      });

      $(".eye").on("click", function () {
        var i = $(this).data("index");
        if (list[i].isConnect == 1) {
          return
        }
        list[i].is_show = list[i].is_show == 0 ? 1 : 0;
        list_init();
      });

      $(".delete").on("click", function () {
        $(".del_tip").show();
        del_index = $(this).data("index");
      });
    }

    function input_blur(i, name, val) {
      if (list[i].isConnect == 1) {
        toast("In use, cannot be edited.")
        return
      }
      list[i][name] = val;
      canSave = true
    }

    function inputPaste(ele) {
      canSave = true
      var i = $(ele).data("index");

      var name = $(ele).attr("class");
      // console.log(i, name)
      if (name == 'Host_name') {
       
        setTimeout(function () {
          var val = $(ele).val();
          if (val.indexOf(":") != -1) {
            var txt_arr = val.split(":");
            const inputParentSilbs = $(ele).parent().parent().siblings()
            if (txt_arr.length == 4) {
              $($(inputParentSilbs[3]).find('input')).val(txt_arr[2])
              $($(inputParentSilbs[4]).find('input')).val(txt_arr[3])
              input_blur(i, 'Username', txt_arr[2]);
              input_blur(i, 'Password', txt_arr[3]);
            }
            $(ele).val(txt_arr[0]);
            // port
            $($(inputParentSilbs[2]).find('input')).val(txt_arr[1])
            input_blur(i, 'Host_name', txt_arr[0]);
            input_blur(i, 'Port', txt_arr[1]);
          }
        }, 100);
      }
    }

    $(".save_btn").on("click", function () {
  
      if (!canSave) {
        toast("No data can be saved.")
        return
      }

      for (var i = 0; i < list.length; i++) {
        if (list[i].Proxy_name == "") {
          toast("Please enter a proxy name.")
          return
        } else if (list[i].Host_name == "") {
          toast("Please enter a host name.")
          return
        } else if (list[i].Port == "") {
          toast("Please enter a port.")
          return
        }
      }

      canSave = false;
      browser.storage.local.set({ list: list }, function () { });

      $(".save_success_tip").fadeIn("slow");
      $(".save_success_tip").fadeIn(1000);
      setTimeout(function () {
        $(".save_success_tip").fadeOut("slow");
        $(".save_success_tip").fadeOut(1000);
      }, 1500);
    })

    $(".del_tip_close_btn").on("click", function () {
      $(".del_tip").hide();
    });

    $(".del_tip_close_btn").on("click", function () {
      $(".del_tip").hide();
    });

    $(".del_tip_Cancel_btn").on("click", function () {
      $(".del_tip").hide();
    });

    $(".del_tip_del_btn").on("click", function () {
      $(".del_tip").hide();
      if (list[del_index]) {
        if (list[del_index].isConnect == 1) {
          toast("In use, cannot be deleted")
          return
        }
        list.splice(del_index, 1)
        canSave = true;
        browser.storage.local.set({ list: list }, function () {
          // toast("Successfully deleted!")
        });
        list_init()
      }
    });

    $('.logo img').on('click', function () {
      // console.log('====', `${webUrl}`);
      activeStatisFun('Manage_website')
      window.open(`${webUrl}`)
    })

    function toast(message) {
      $(".save_fail_tip .msg").text(message)
      $(".save_fail_tip").fadeIn("slow");
      $(".save_fail_tip").fadeIn(1000);
      setTimeout(function () {
        $(".save_fail_tip").fadeOut("slow");
        $(".save_fail_tip").fadeOut(1000);
      }, 1500);
    }
  }
}

$(function () {
  loadView.init()
})
