let isNotDirect = false;
let hostValue = "";
let portValue = 0;
let typeValue = "";
let isActive = false

// Set the default list on installation.
chrome.runtime.onInstalled.addListener(details => {
	// console.log(`detail: ${details}`);
	// Get the stored list
	chrome.storage.local.get(data => {
		if (typeof data.config != 'undefined' && data.config.direct == false) {
				isActive = true
			} else {
				isActive = false
			}
			updateIcon()
	});
});

chrome.storage.onChanged.addListener((changes, namespace) => {

	if (typeof changes.config != 'undefined') {
		if (changes.config.newValue.direct == true) {
			clearProxy()
		} else {
			setProxy(changes.config.newValue.host,
				changes.config.newValue.port,
				changes.config.newValue.userN,
				changes.config.newValue.pw
			)
		}
	}
});

// Listen for send message
chrome.runtime.onMessage.addListener((message) => {
	if (message.action === 'setProxy'
		&& message.config.host.length > 0) {
		console.log("setProxy");
		chrome.storage.local.set({ config: message.config })
	} else if (message.action === 'clearProxy') {
		console.log("clearProxy");
		chrome.storage.local.set({ config: message.config })
	}
});

function setProxy(proxyhost, proxyport, username, password) {

	var config = {
		mode: "pac_script",
		pacScript: {
			data: getPacjs("HTTP", proxyhost, proxyport, username, password)
		}
	}

	chrome.proxy.settings.set(
		{ value: config, scope: "regular" },
		() => {
			// console.log("turned proxy on", config);
			isActive = true;
			updateIcon();
		}
	);
}

function getPacjs(type, host, port, username, password) {
	if (type == "HTTP" || type == "HTTPS" || type == "socks5") {
		type = "PROXY";
	}

	var ipValue = host + ':' + port

	if (username.length > 0 && password.length > 0) {
		var authorization = "Proxy-Authorization: "
		var credentials = "Basic " + "username:password";
		var data = `
    function FindProxyForURL(url, host) {
				return "${type + " " + ipValue};${authorization + " " + credentials}"
    }`
		return data
	} else {
		var data = `
    function FindProxyForURL(url, host) {
				return "${type + " " + ipValue}"
    }`
		return data
	}
}

function clearProxy() {
	chrome.proxy.settings.set(
		{ value: { mode: "system" }, scope: "regular" },
		() => {
			isActive = false;
			updateIcon();
		}
	);
}

// update icon
function updateIcon() {
	const iconPath = isActive ? {
		"16": "/img/logo_on16.png",
		"32": "/img/logo_on32.png",
		"48": "/img/logo_on48.png",
		"128": "/img/logo_on128.png"
	} : {
			"16": "/img/logo16.png",
			"32": "/img/logo32.png",
			"48": "/img/logo48.png",
			"128": "/img/logo128.png"
	};

	chrome.action.setIcon({ path: iconPath });
}